/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemStackMap;
import codechicken.nei.api.ItemFilter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemStackSet
implements ItemFilter {
    ItemStackMap<Object> underlying = new ItemStackMap();

    public ItemStackSet with(ItemStack ... items) {
        for (ItemStack item : items) {
            this.add(item);
        }
        return this;
    }

    public ItemStackSet with(Item ... items) {
        for (Item item : items) {
            this.add(ItemStackMap.wildcard(item));
        }
        return this;
    }

    public ItemStackSet with(Block ... blocks) {
        for (Block block : blocks) {
            this.add(ItemStackMap.wildcard(Item.func_150898_a((Block)block)));
        }
        return this;
    }

    public void add(ItemStack item) {
        this.underlying.put(item, new Object());
    }

    public boolean remove(ItemStack item) {
        return this.underlying.remove(item) != null;
    }

    public boolean contains(ItemStack item) {
        return this.underlying.get(item) != null;
    }

    public boolean containsAll(Item item) {
        return this.underlying.get(ItemStackMap.wildcard(item)) != null;
    }

    public List<ItemStack> values() {
        return this.underlying.keys();
    }

    public void clear() {
        this.underlying.clear();
    }

    @Override
    public boolean matches(ItemStack item) {
        return this.contains(item);
    }

    public int size() {
        return this.underlying.size();
    }

    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    public static ItemStackSet of(Block ... blocks) {
        return new ItemStackSet().with(blocks);
    }

    public static ItemStackSet of(Item ... items) {
        return new ItemStackSet().with(items);
    }

    public static ItemStackSet of(ItemStack ... items) {
        return new ItemStackSet().with(items);
    }
}

