--[[
SimpleMD_Options - LoD option module for SimpleMD
Author: Michael Joseph Murray aka Lyte of Lothar(US)
$Revision: 227 $
$Date: 2011-01-21 07:58:13 +0000 (Fri, 21 Jan 2011) $
Project Version: 3.3.5
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2011 Michael J. Murray aka Lyte of Lothar(US)
All rights reserved unless otherwise explicitly stated.
]]

local L = LibStub("AceLocale-3.0"):GetLocale("SimpleMD")
local LSM = LibStub("LibSharedMedia-3.0")
local smd = LibStub("AceAddon-3.0"):GetAddon("SimpleMD")

local handler = {}
function handler:Set(info, ...)
	if info.type == "color" then
		local color = smd.db.profile[info.arg]
		color[1], color[2], color[3] = ...
	else
		smd.db.profile[info.arg] = ...
	end
	self:Update()
end

function handler:Get(info, ...)
	if info.type == "color" then
		return unpack(smd.db.profile[info.arg])
	else
		return smd.db.profile[info.arg]
	end
end

function handler:Update()
	for k, v in pairs(smd.timerbars) do
		smd.timerbars[k].timerbg:SetAlpha(smd.db.profile.bg_alpha)
		
		smd.timerbars[k].timer:SetStatusBarTexture(LSM:Fetch('statusbar', smd.db.profile.texture))
		smd.timerbars[k].timer:GetStatusBarTexture():SetHorizTile(false)
		smd.timerbars[k].timer:GetStatusBarTexture():SetVertTile(false)
		
		smd.timerbars[k].redirect:SetStatusBarTexture(LSM:Fetch('statusbar', smd.db.profile.texture))
		smd.timerbars[k].redirect:GetStatusBarTexture():SetHorizTile(false)
		smd.timerbars[k].redirect:GetStatusBarTexture():SetVertTile(false)
		
		smd.timerbars[k].text:SetFont(LSM:Fetch('font', smd.db.profile.font), smd.db.profile.textSize)
		smd.timerbars[k].timetext:SetFont(LSM:Fetch('font', smd.db.profile.font), smd.db.profile.textSize)
		smd.timerbars[k].redirecttext:SetFont(LSM:Fetch('font', smd.db.profile.font), smd.db.profile.textSize)
		smd.timerbars[k].text2:SetFont(LSM:Fetch('font', smd.db.profile.font), smd.db.profile.textSize)
		
		smd.timerbars[k].text:SetTextColor(smd.db.profile.barTextColor[1], smd.db.profile.barTextColor[2], smd.db.profile.barTextColor[3], 1)
		smd.timerbars[k].timetext:SetTextColor(smd.db.profile.barTextColor[1], smd.db.profile.barTextColor[2], smd.db.profile.barTextColor[3], 1)
		smd.timerbars[k].redirecttext:SetTextColor(smd.db.profile.barTextColor[1], smd.db.profile.barTextColor[2], smd.db.profile.barTextColor[3], 1)
		smd.timerbars[k].text2:SetTextColor(smd.db.profile.barTextColor[1], smd.db.profile.barTextColor[2], smd.db.profile.barTextColor[3], 1)
		
		smd.timerbars[k]:SetWidth(smd.db.profile.barWidth * smd.db.profile.barScale)
		smd.timerbars[k]:SetHeight(smd.db.profile.barHeight * smd.db.profile.barScale)
		smd.timerbars[k].icon:SetWidth(smd.db.profile.barHeight * smd.db.profile.barScale)
		smd.timerbars[k].icon:SetHeight(smd.db.profile.barHeight * smd.db.profile.barScale)
		smd.timerbars[k].text:SetWidth(smd.db.profile.barWidth * smd.db.profile.barScale)
		smd.timerbars[k].text:SetHeight(smd.db.profile.barHeight * smd.db.profile.barScale)
		smd.timerbars[k].timetext:SetWidth(smd.db.profile.barWidth * smd.db.profile.barScale)
		smd.timerbars[k].timetext:SetHeight(smd.db.profile.barHeight * smd.db.profile.barScale)
		
		smd.timerbars[k].reversed = smd.db.profile.reverse
		smd.timerbars[k].growup = smd.db.profile.growUp
		smd.timerbars[k].stayonscreen = smd.db.profile.stay
	end
	
	smd:ReanchorTimerBars(smd.db.profile.growUp)
	
	if not smd.db.profile.stay then
		smd:ClearTimerBars()
	end
	
	--update prefix tables
	smd.msgToText = {
		["SMDFIVE"] = smd.db.profile.fiveCD,
		["SMDTEN"] = smd.db.profile.tenCD,
		["SMDFIFTEEN"] = smd.db.profile.fifteenCD,
		["SMDREADY"] = smd.db.profile.noCD,
		["SMDFIVE_R"] = smd.db.profile.tott_fiveCD,
		["SMDTEN_R"] = smd.db.profile.tott_tenCD,
		["SMDFIFTEEN_R"] = smd.db.profile.tott_fifteenCD,
		["SMDREADY_R"] = smd.db.profile.tott_noCD,
	}
	
	smd.msgToDisplayOption = {
		["SMDFIVE"] = smd.db.profile.five,
		["SMDTEN"] = smd.db.profile.ten,
		["SMDFIFTEEN"] = smd.db.profile.fifteen,
		["SMDREADY"] = smd.db.profile.ready,
		["SMDFIVE_R"] = smd.db.profile.five,
		["SMDTEN_R"] = smd.db.profile.ten,
		["SMDFIFTEEN_R"] = smd.db.profile.fifteen,
		["SMDREADY_R"] = smd.db.profile.ready,
	}
end

local opts = {
	type = 'group',
	handler = handler,
	args = {
		anchor = {
			type = 'execute',
			name = L["Anchor"],
			desc = L["Show the dragable anchor."],
			func = function()
				if smd.anchor:IsVisible() then
					smd.anchor:Hide()
				else
					smd.anchor:Show()
				end
			end,
			order = 1,
		},
		bars = {
			type = 'group',
			name = L["Bar"],
			desc = L["Bar Options"],
			order = 2,
			args = {
				texture = {
					type = 'select',
					name = L["Bar Texture"],
					desc = L["Bar Texture"],
					arg = "texture",
					get = "Get",
					set = "Set",
					dialogControl = "LSM30_Statusbar",
					values = AceGUIWidgetLSMlists.statusbar,
					order = 1,
				},
				bgalpha = {
					type = 'range',
					name = L["Background Alpha"],
					desc = L["Set the bar background alpha."],
					arg = "bg_alpha",
					get = "Get",
					set = "Set",
					min = 0.0,
					max = 1.0,
					step = 0.01,
					order = 2,
				},
				text = {
					type = 'select',
					name = L["Font"],
					desc = L["Font"],
					arg = "font",
					get = "Get",
					set = "Set",
					dialogControl = "LSM30_Font",
					values = AceGUIWidgetLSMlists.font,
					order = 3,
				},
				textcolor = {
					type = 'color',
					name = L["Text Color"],
					desc = L["Set the bar text color."],
					arg = "barTextColor",
					get = "Get",
					set = "Set",
					order = 4,
				},
				textsize = {
					type = 'range',
					name = L["Text Size"],
					desc = L["Set the bar text size."],
					arg = "textSize",
					get = "Get",
					set = "Set",
					min = 8,
					max = 20,
					step = 0.5,
					order = 5,
				},
				scale = {
					type = 'range',
					name = L["Bar Scale"],
					desc = L["Set the bar scale."],
					arg = "barScale",
					get = "Get",
					set = "Set",
					min = 0.5,
					max = 1.5,
					step = 0.1,
					order = 6,
				},
				height = {
					type = 'range',
					name = L["Bar Height"],
					desc = L["Set the bar height."],
					arg = "barHeight",
					get = "Get",
					set = "Set",
					min = 8,
					max = 30,
					step = 0.5,
					order = 7,
				},
				width = {
					type = 'range',
					name = L["Bar Width"],
					desc = L["Set the bar width."],
					arg = "barWidth",
					get = "Get",
					set = "Set",
					min = 50,
					max = 300,
					step = 1.0,
					order = 8,
				},
				growth = {
					type = 'toggle',
					name = L["Grow Up"],
					desc = L["Toggle the bar growing upwards or downwards."],
					arg = "growUp",
					get = "Get",
					set = "Set",
					order = 9,
				},
				reverse = {
					type = 'toggle',
					name = L["Reverse"],
					desc = L["Toggle the bar fill direction."],
					arg = "reverse",
					get = "Get",
					set = "Set",
					order = 10,
				},
				stay = {
					type = 'toggle',
					name = L["Static Bars"],
					desc = L["Toggle the static bars feature"],
					arg = "stay",
					get = "Get",
					set = "Set",
					order = 11,
				},
				md_header = {
					type = 'header',
					order = 12,
					name = GetSpellInfo(34477),
				},
				color = {
					type = 'color',
					name = L["Bar Color"],
					desc = L["Set the default bar color."],
					arg = "barColor",
					get = "Get",
					set = "Set",
					order = 13,
				},
				transferColor = {
					type = 'color',
					name = L["Threat Transfer Color"],
					desc = L["Set the bar color when transferring threat."],
					arg = "transferColor",
					get = "Get",
					set = "Set",
					order = 14,
				},
				cooldownColor = {
					type = 'color',
					name = L["Cooldown Color"],
					desc = L["Set the bar color when Misdirection is on cooldown."],
					arg = "cooldownColor",
					get = "Get",
					set = "Set",
					order = 15,
				},
				bgcolor = {
					type = 'color',
					name = L["Background Color"],
					desc = L["Set the bar background color."],
					arg = "bgColor",
					get = "Get",
					set = "Set",
					order = 16,
				},
				transferbgcolor = {
					type = 'color',
					name = L["Transfer Bar Background Color"],
					desc = L["Set the transfer bar background color."],
					arg = "transferBG",
					get = "Get",
					set = "Set",
					order = 17,
				},
				tott_header = {
					type = 'header',
					order = 18,
					name = GetSpellInfo(57934),
				},
				tottcolor = {
					type = 'color',
					name = L["Bar Color"],
					desc = L["Set the default bar color."],
					arg = "tott_barColor",
					get = "Get",
					set = "Set",
					order = 19,
				},
				totttransferColor = {
					type = 'color',
					name = L["Threat Transfer Color"],
					desc = L["Set the bar color when transferring threat."],
					arg = "tott_transferColor",
					get = "Get",
					set = "Set",
					order = 20,
				},
				tottcooldownColor = {
					type = 'color',
					name = L["Cooldown Color"],
					desc = L["Set the bar color when Misdirection is on cooldown."],
					arg = "tott_cooldownColor",
					get = "Get",
					set = "Set",
					order = 21,
				},
				tottbgcolor = {
					type = 'color',
					name = L["Background Color"],
					desc = L["Set the bar background color."],
					arg = "tott_bgColor",
					get = "Get",
					set = "Set",
					order = 22,
				},
				totttransferbgcolor = {
					type = 'color',
					name = L["Transfer Bar Background Color"],
					desc = L["Set the transfer bar background color."],
					arg = "tott_transferBG",
					get = "Get",
					set = "Set",
					order = 23,
				},
			},
		},
		messages = {
			type = 'group',
			name = L["Message Text Options"],
			desc = L["Options for setting the various alert texts"],
			order = 4,
			args = {
				mdHeader = {
					type = 'header',
					order = 1,
					name = GetSpellInfo(34477),
				},
				fivesec = {
					type = 'input',
					name = L["5 Second Warning"],
					desc = L["Set Five Seconds Remaining Message. NOTE: Use %s once to insert a name."],
					arg = "fiveCD",
					get = "Get",
					set = "Set",
					order = 2,
				},
				tensec = {
					type = 'input',
					name = L["10 Second Warning"],
					desc = L["Set Ten Seconds Remaining Message. NOTE: Use %s once to insert a name."],
					arg = "tenCD",
					get = "Get",
					set = "Set",
					order = 3,
				},
				fifteensec = {
					type = 'input',
					name = L["15 Second Warning"],
					desc = L["Set Fifteen Seconds Remaining Message. NOTE: Use %s once to insert a name."],
					arg = "fifteenCD",
					get = "Get",
					set = "Set",
					order = 4,
				},
				cddone = {
					type = 'input',
					name = L["Cooldown Finished Warning"],
					desc = L["Set Cooldown Finished Message. NOTE: Use %s once to insert a name."],
					arg = "noCD",
					get = "Get",
					set = "Set",
					order = 5,
				},
				readiness = {
					type = 'input',
					name = L["Readiness Warning"],
					desc = L["Set Readiness Message. NOTE: Use %s once to insert a name."],
					arg = "readiness",
					get = "Get",
					set = "Set",
					order = 6,
				},
				tottHeader = {
					type = 'header',
					order = 7,
					name = GetSpellInfo(57934),
				},
				tottfivesec = {
					type = 'input',
					name = L["5 Second Warning"],
					desc = L["Set Five Seconds Remaining Message. NOTE: Use %s once to insert a name."],
					arg = "tott_fiveCD",
					get = "Get",
					set = "Set",
					order = 8,
				},
				totttensec = {
					type = 'input',
					name = L["10 Second Warning"],
					desc = L["Set Ten Seconds Remaining Message. NOTE: Use %s once to insert a name."],
					arg = "tott_tenCD",
					get = "Get",
					set = "Set",
					order = 9,
				},
				tottfifteensec = {
					type = 'input',
					name = L["15 Second Warning"],
					desc = L["Set Fifteen Seconds Remaining Message. NOTE: Use %s once to insert a name."],
					arg = "tott_fifteenCD",
					get = "Get",
					set = "Set",
					order = 10,
				},
				tottcddone = {
					type = 'input',
					name = L["Cooldown Finished Warning"],
					desc = L["Set Cooldown Finished Message. NOTE: Use %s once to insert a name."],
					arg = "tott_noCD",
					get = "Get",
					set = "Set",
					order = 11,
				},
				color = {
					type = 'color',
					name = L["Message Text Color"],
					desc = L["Set the color of the messages shown in Floating Combat Text"],
					arg = "txtColor",
					get = "Get",
					set = "Set",
					order = 20,
				},
			},
		},
		broadcast = {
			type = 'group',
			name = L["Broadcast Options"],
			desc = L["Options for how and where the alerts are displayed"],
			order = 5,
			args = {
				console = {
					type = 'toggle',
					name = L["Show in Chat"],
					desc = L["Toggles the display of the alerts as self messages"],
					arg = "showInChat",
					get = "Get",
					set = "Set",
				},
				channel = {
					type = 'toggle',
					name = L["Show in Channel"],
					desc = L["Toggles broadcasting of alerts to a user defined channel"],
					arg = "showInChannel",
					get = "Get",
					set = "Set",
				},
				floating = {
					type = 'toggle',
					name = L["Show in Combat Text"],
					desc = L["Toggles showing alerts in popular SCT like mods"],
					arg = "showFloating",
					get = "Get",
					set = "Set",
				},
				showSelf = {
					type = 'toggle',
					name = L["Show Own Alerts"],
					desc = L["Toggles showing your alerts on your client"],
					arg = "showSelf",
					get = "Get",
					set = "Set",
				},
				channelName = {
					type = 'input',
					name = L["Custom Channel"],
					arg = "channel",
					get = "Get",
					set = "Set",
				},
				raidwarning = {
					type = 'toggle',
					name = L["Show in Raid Warning"],
					desc = L["Broadcast Misdirection casts to Raid Warning"],
					arg = "showRW",
					get = "Get",
					set = "Set",
				},
				showgain = {
					type = 'toggle',
					name = L["Show Gain Message"],
					desc = L["Toggles the display and broadcast of the Gain message"],
					arg = "showGain",
					get = "Get",
					set = "Set",
				},
				showfade = {
					type = 'toggle',
					name = L["Show Faded Message"],
					desc = L["Toggles the display and broadcast of the Faded message"],
					arg = "showFade",
					get = "Get",
					set = "Set",
				},
				party = {
					type = 'toggle',
					name = L["Show in Party Chat"],
					desc = L["Toggles broadcasting alerts to Party chat"],
					arg = "showParty",
					get = "Get",
					set = "Set",
				},
				raid = {
					type = 'toggle',
					name = L["Show in Raid Chat"],
					desc = L["Toggles broadcasting alerts to Raid chat"],
					arg = "showRaid",
					get = "Get",
					set = "Set",
				},
				yell = {
					type = 'toggle',
					name = L["Show in Yells"],
					desc = L["Toggles broadcasting alerts to Yells"],
					arg = "showYell",
					get = "Get",
					set = "Set",
				},
			},
		},
		cooldowns = {
			type = 'group',
			name = L["Cooldown Broadcast Options"],
			desc = L["Toggle which cooldown warnings you want to display"],
			order = 6,
			args = {
				bars = {
					type = 'toggle',
					name = L["Show Cooldown Bars"],
					desc = L["Toggles the creation of cooldown bars"],
					arg = "showBars",
					get = "Get",
					set = "Set",
				},
				ready = {
					type = 'toggle',
					name = L["CD Finished Warning"],
					desc = L["Display a warning when MD cooldown finishes"],
					arg = "ready",
					get = "Get",
					set = "Set",
				},
				readiness = {
					type = 'toggle',
					name = L["Readiness Message"],
					desc = L["Toggle showing readiness messages"],
					arg = "showReadiness",
					get = "Get",
					set = "Set",
				},
				ten = {
					type = 'toggle',
					name = L["10 Second Warning"],
					desc = L["Display a warning with 10 seconds left on MD cooldown"],
					arg = "ten",
					get = "Get",
					set = "Set",
				},
				five = {
					type = 'toggle',
					name = L["5 Second Warning"],
					desc = L["Display a warning with 5 seconds left on MD cooldown"],
					arg = "five",
					get = "Get",
					set = "Set",
				},
				fifteen = {
					type = 'toggle',
					name = L["15 Second Warning"],
					desc = L["Display a warning with 15 seconds left on MD cooldown"],
					arg = "fifteen",
					get = "Get",
					set = "Set",
				},
			},
		},
	},
}

--add LibSink-2.0 controls
opts.args.output = smd:GetSinkAce3OptionsDataTable()
--add profile controls
opts.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(smd.db)

LibStub("AceConfig-3.0"):RegisterOptionsTable("SimpleMD", opts)
LibStub("AceConfigDialog-3.0"):SetDefaultSize("SimpleMD", 500, 550)
LibStub("AceConfigDialog-3.0"):AddToBlizOptions("SimpleMD", "SimpleMD")
