﻿--[[
SimpleMD
Author: Michael Joseph Murray aka Lyte of Lothar(US)
$Revision: 235 $
$Date: 2011-06-28 16:31:46 +0000 (Tue, 28 Jun 2011) $
Project Version: 3.3.5
contact: codemaster2010 AT gmail DOT com

Copyright (c) 2007-2011 Michael J. Murray aka Lyte of Lothar(US)
All rights reserved unless otherwise explicitly stated.
]]

SimpleMD = LibStub("AceAddon-3.0"):NewAddon("SimpleMD", "AceConsole-3.0", "AceComm-3.0", "AceTimer-3.0", "AceEvent-3.0", "LibSink-2.0")
local LSM = LibStub("LibSharedMedia-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("SimpleMD")

--upvalue frequently used globals
local strformat = string.format
local select = select
local unpack = unpack

--save the player's name for later identification
local pname = UnitName("player")
--timer handles for player cooldown
local aceTimers = {}
--checks for the CLEU handler
local mdOnCD
local isTransferring = {}
local rottenTricks = {}

--this allows us to disable bars/broadcasts in pvp settings where braodcasting can spam "You aren't in a party."
local allowedZones = {["none"] = true, ["pvp"] = false, ["arena"] = false, ["raid"] = true, ["party"] = true}

--function to determine if broadcasts should be sent
--we only broadcast if we are in a group (raid/party) and if we are in a non-pvp zone
local function IsInGroup()
	if (UnitInRaid("player") or GetNumPartyMembers() > 0) and allowedZones[select(2, IsInInstance())] then
		return true
	else
		return false
	end
end

function SimpleMD:OnInitialize()
	local defaults = {
		profile = {
			tenCD = L["%s has 10 seconds left on MD cooldown!"],
			fiveCD = L["%s has 5 seconds left on MD cooldown!"],
			fifteenCD = L["%s has 15 seconds left on MD cooldown!"],
			noCD = L["%s has MD ready!"],
			readiness = L["%s used Readiness! MD ready!"],
			tott_tenCD = L["%s has 10 seconds left on Tricks cooldown!"],
			tott_fiveCD = L["%s has 5 seconds left on Tricks cooldown!"],
			tott_fifteenCD = L["%s has 15 seconds left on Tricks cooldown!"],
			tott_noCD = L["%s has Tricks ready!"],
			channel = "",
			showInChannel = false,
			showInChat = false,
			showFloating = false,
			showSelf = true,
			showRW = false,
			showParty = false,
			showRaid = false,
			showYell = false,
			showBars = true,
			showGain = true,
			showFade = true,
			ready = true,
			ten = true,
			five = false,
			fifteen = false,
			showReadiness = true,
			texture = "Blizzard",
			font = "Friz Quadrata TT",
			--the normal bar color
			barColor = {0, 0.4, 0.08},
			tott_barColor = {0, 0.4, 0.08},
			--the color when transfering threat
			transferColor = {1, 1, 0},
			tott_transferColor = {1, 1, 0},
			--the color when finished transfering and on CD
			cooldownColor = {0, 0, 1},
			tott_cooldownColor = {0, 0, 1},
			--the color of the background of the timer bar
			bgColor = {0, 1, 0.04},
			tott_bgColor = {0, 1, 0.04},
			--the color of the background of the transfer bar
			transferBG = {1, 1, 0.59},
			tott_transferBG = {1, 1, 0.59},
			--the text color for the timer bars
			barTextColor = {1, 1, 1},
			--the text color for alerts
			txtColor = {1, 1, 1},
			bg_alpha = 1.0,
			textSize = 11,
			barScale = 1.0,
			barWidth = 195.00,
			barHeight = 17.00,
			growUp = false,
			reverse = false,
			stay = false,
			position = {},
			sinkOpts = {},
		}
	}

	self.db = LibStub("AceDB-3.0"):New("SimplemdDB", defaults, "Default")
	self.db.RegisterCallback(self, "OnProfileReset", "Reset")
	self.db.RegisterCallback(self, "OnProfileCopied", "Refresh")
	self.db.RegisterCallback(self, "OnProfileChanged", "Refresh")
	self:SetSinkStorage(self.db.profile.sinkOpts)
	
	--setup the addonID
	local ver, rev = "3.0", "235"
	rev = tonumber(rev) or -1
	local addonID
	if rev == -1 then
		addonID = "SimpleMD-" .. ver .. " SOURCE"
	else
		addonID = "SimpleMD-" .. ver .. " r" .. rev
	end
	
	--self.frame is an invisible frame to run the OnUpdate
	self.anchor, self.frame = self:CreateAnchor(addonID)
	self.timerbars = {} --storage for timer bars
	self.recyclePile = {} --hold on to the frames to reuse them
	self.idents = {} --map of caster to bar ref
	self.activeTransfers = {}
	
	--mapping of the possible incoming comm message
	--to the human friendly broadcasts
	self.msgToText = {
		["SMDFIVE"] = self.db.profile.fiveCD,
		["SMDTEN"] = self.db.profile.tenCD,
		["SMDFIFTEEN"] = self.db.profile.fifteenCD,
		["SMDREADY"] = self.db.profile.noCD,
		["SMDFIVE_R"] = self.db.profile.tott_fiveCD,
		["SMDTEN_R"] = self.db.profile.tott_tenCD,
		["SMDFIFTEEN_R"] = self.db.profile.tott_fifteenCD,
		["SMDREADY_R"] = self.db.profile.tott_noCD,
	}
	
	self.msgToDisplayOption = {
		["SMDFIVE"] = self.db.profile.five,
		["SMDTEN"] = self.db.profile.ten,
		["SMDFIFTEEN"] = self.db.profile.fifteen,
		["SMDREADY"] = self.db.profile.ready,
		["SMDFIVE_R"] = self.db.profile.five,
		["SMDTEN_R"] = self.db.profile.ten,
		["SMDFIFTEEN_R"] = self.db.profile.fifteen,
		["SMDREADY_R"] = self.db.profile.ready,
	}
	
	self:RegisterChatCommand("smd", "OpenConfig", true, true)
	self:RegisterChatCommand("simplemd", "OpenConfig")
end

function SimpleMD:OnEnable()
	self.md_tex = [[Interface\Icons\ability_hunter_misdirection]]
	self.tott_tex = [[Interface\Icons\ability_rogue_tricksofthetrade]]
	self:RegisterComm("SimpleMD", "OnCommReceive")
	
	--to clear bars after leaving a raid/party
	self:RegisterEvent("RAID_ROSTER_UPDATE", "GroupStatus") 
	self:RegisterEvent("PARTY_MEMBERS_CHANGED", "GroupStatus")
	
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
end

function SimpleMD:Reset()
	self.anchor:ClearAllPoints()
	self.frame:ClearAllPoints()
	self.anchor:SetPoint("CENTER", UIParent, "CENTER")
	self.frame:SetPoint("CENTER", UIParent, "CENTER")
end

function SimpleMD:Refresh()
	local db = self.db.profile
	self.anchor:ClearAllPoints()
	self.frame:ClearAllPoints()
	if db.position.x then
		self.anchor:SetPoint(db.position.point, UIParent, db.position.anchor, db.position.x, db.position.y)
		self.frame:SetPoint(db.position.point, UIParent, db.position.anchor, db.position.x, db.position.y)
	else
		self.anchor:SetPoint("CENTER", UIParent, "CENTER")
		self.frame:SetPoint("CENTER", UIParent, "CENTER")
	end
end

function SimpleMD:OpenConfig()
	LoadAddOn("SimpleMD_Options")
	LibStub("AceConfigDialog-3.0"):Open("SimpleMD")
end

function SimpleMD:OnCommReceive(prefix, message, distro, sender)
	if sender ~= pname then
		if self.msgToText[message] and self.msgToDisplayOption[message] then
			self:PrintMessage(strformat(self.msgToText[message], sender), false)
		end
	end
end

--dispatcher function to send to the right comm channel
function SimpleMD:Dispatch(message)
	if allowedZones[select(2, IsInInstance())] then
		if UnitInRaid("player") then
			self:SendCommMessage("SimpleMD", message, "RAID", nil, "NORMAL")
		elseif GetNumPartyMembers() > 0 then
			self:SendCommMessage("SimpleMD", message, "PARTY", nil, "NORMAL")
		end
	end
end

function SimpleMD:PrintMessage(message, isPlayer)
	--if isPlayer is true the message regards the player and the message needs to
	--be sent to any selected channels, if it is false then the message is about another hunter
	--and should only be displayed locally to the player
	
	if isPlayer then
		--print to chat frame
		if self.db.profile.showInChat and self.db.profile.showSelf then
			self:Print(message)
		end
		--print to Party chat
		if self.db.profile.showParty and GetNumPartyMembers() > 0 and GetNumRaidMembers() == 0 then
			SendChatMessage(message, "PARTY")
		end
		--print to Raid Chat
		if self.db.profile.showRaid and UnitInRaid("player") then
			SendChatMessage(message, "RAID")
		end
		--print to Raid Warning
		if (IsRaidLeader() or IsRaidOfficer()) and self.db.profile.showRW then
			SendChatMessage(message, "RAID_WARNING")
		end
		-- print to custom channel
		if self.db.profile.showInChannel and self.db.profile.channel ~= "" then
			SendChatMessage(message, "CHANNEL", nil, GetChannelName(self.db.profile.channel))
		end
		--print to Scrolling Text
		if self.db.profile.showFloating and self.db.profile.showSelf then
			self:Pour(message, self.db.profile.txtColor[1], self.db.profile.txtColor[2], self.db.profile.txtColor[3])
		end
	else
		--print to Scrolling Text mod
		if self.db.profile.showFloating then
			self:Pour(message, self.db.profile.txtColor[1], self.db.profile.txtColor[2], self.db.profile.txtColor[3])
		end
		--print to chat frame
		if self.db.profile.showInChat then
			self:Print(message)
		end
	end
end

local function mdCD_Done() mdOnCD = nil end

-- 34477 misdirect
-- 35079 misdirect transfer buff
-- 23989 readiness
-- 57934 tricks of the trade
-- 59628 tricks of the trade transfer buff
function SimpleMD:COMBAT_LOG_EVENT_UNFILTERED(_, _, subevent, _, _, sName, _, _, _, dName, _, _, spellID)
	if spellID == 34477 or spellID == 57934 then
		if subevent == "SPELL_CAST_SUCCESS" then
			if IsInGroup() then
				if self.db.profile.showBars then
					self:CreateTimerBar(sName, dName, 20, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp, spellID == 34477)
				end
				if self.db.profile.showGain then
					if spellID == 34477 then
						self:PrintMessage(strformat(L["%s cast Misdirection on %s"], sName, dName), sName == pname)
					else
						self:PrintMessage(strformat(L["%s cast Tricks on %s"], sName, dName), sName == pname)
					end
				end
				if spellID == 57934 then
					--19.8 is sort of a magic number for the timer duration
					--20 seconds creates a race condition with the combat log
					--and the 0.2 second window seems small enough to not cause issues under real raid conditions
					self.activeTransfers[sName] = self:ScheduleTimer("BuffRotCheck", 19.8, sName)
				end
			end
		elseif subevent == "SPELL_AURA_REMOVED" then
			--when MD fades or is cancelled there is no cooldown
			--when Tricks fades there is no cooldown
			--when Tricks is cancelled there is a cooldown
			if (not isTransferring[sName]) and (not rottenTricks[sName]) and IsInGroup() then
				--deal with faded/cancelled Misdirection
				if spellID == 34477 and self.idents[sName] then
					--stop the timerbar
					self:StopTimerBar(self:GetTimerIndexByName(sName))
					return
				end
				
				--deal with cancelled Tricks
				--the Rot check should take care of timeout fades
				self:CancelTimer(self.activeTransfers[sName])
				self.activeTransfers[sName] = nil
				if self.db.profile.showBars and self.idents[sName] then
					local r, g, b = unpack(spellID == 34477 and self.db.profile.cooldownColor or self.db.profile.tott_cooldownColor)
					self.idents[sName].timer:SetStatusBarColor(r, g, b, 1)
					local curTime = GetTime()
					self.idents[sName].start = curTime
					self.idents[sName].stop = curTime + 30
					self.idents[sName].time = 30
				end
				if sName == pname then
					--delayed messages displayed on the user's screen
					if self.db.profile.fifteen then
						aceTimers["fif"] = self:ScheduleTimer("CooldownBroadcast", 15, strformat(self.db.profile.tott_fifteenCD, pname))
					end
					if self.db.profile.ten then
						aceTimers["ten"] = self:ScheduleTimer("CooldownBroadcast", 20, strformat(self.db.profile.tott_tenCD, pname))
					end
					if self.db.profile.five then
						aceTimers["five"] = self:ScheduleTimer("CooldownBroadcast", 25, strformat(self.db.profile.tott_fiveCD, pname))
					end
					if self.db.profile.ready then
						aceTimers["done"] = self:ScheduleTimer("CooldownBroadcast", 30, strformat(self.db.profile.tott_noCD, pname))
					end
					
					--delayed broadcasts for other users of the addon grouped with this user
					aceTimers["fif_comm"] = self:ScheduleTimer("Dispatch", 15, "SMDFIFTEEN_R")
					aceTimers["ten_comm"] = self:ScheduleTimer("Dispatch", 20, "SMDTEN_R")
					aceTimers["five_comm"] = self:ScheduleTimer("Dispatch", 25, "SMDFIVE_R")
					aceTimers["done_comm"] = self:ScheduleTimer("Dispatch", 30, "SMDREADY_R")
					
					--reset the CD flag in 30 seconds
					aceTimers["done_flag"] = self:ScheduleTimer(mdCD_Done, 30)
					mdOnCD = true
				end
			end
			rottenTricks[sName] = nil
		end
	--this is the 4 second buff that actually allows threat transfer
	elseif spellID == 35079 or spellID == 59628 then
		if subevent == "SPELL_AURA_APPLIED" then
			if IsInGroup() then
				self:CancelTimer(self.activeTransfers[sName]) --cancel the rot check
				isTransferring[sName] = true
				self.activeTransfers[sName] = nil
				if self.db.profile.showBars and self.idents[sName] then
					local curTime = GetTime()
					--update the bar to the transfer color/time
					self.idents[sName].redirectStart = curTime
					self.idents[sName].start = curTime
					self.idents[sName].stop = curTime + 30
					self.idents[sName].timer:Hide()
					self.idents[sName].redirect:Show()
					self.idents[sName].redirecting = true
					self.idents[sName].time = 30
				end
				if sName == pname then
					--delayed messages displayed on the user's screen
					if self.db.profile.fifteen then
						aceTimers["fif"] = self:ScheduleTimer("CooldownBroadcast", 15, strformat(spellID == 35079 and self.db.profile.fifteenCD or self.db.profile.tott_fifteenCD, pname))
					end
					if self.db.profile.ten then
						aceTimers["ten"] = self:ScheduleTimer("CooldownBroadcast", 20, strformat(spellID == 35079 and self.db.profile.tenCD or self.db.profile.tott_tenCD, pname))
					end
					if self.db.profile.five then
						aceTimers["five"] = self:ScheduleTimer("CooldownBroadcast", 25, strformat(spellID == 35079 and self.db.profile.fiveCD or self.db.profile.tott_fiveCD, pname))
					end
					if self.db.profile.ready then
						aceTimers["done"] = self:ScheduleTimer("CooldownBroadcast", 30, strformat(spellID == 35079 and self.db.profile.noCD or self.db.profile.tott_noCD, pname))
					end
					
					--delayed broadcasts for other users of the addon grouped with this user
					aceTimers["fif_comm"] = self:ScheduleTimer("Dispatch", 15, spellID == 35079 and "SMDFIFTEEN" or "SMDFIFTEEN_R")
					aceTimers["ten_comm"] = self:ScheduleTimer("Dispatch", 20, spellID == 35079 and "SMDTEN" or "SMDTEN_R")
					aceTimers["five_comm"] = self:ScheduleTimer("Dispatch", 25, spellID == 35079 and "SMDFIVE" or "SMDFIVE_R")
					aceTimers["done_comm"] = self:ScheduleTimer("Dispatch", 30, spellID == 35079 and "SMDREADY" or "SMDREADY_R")
					
					--reset the CD flag in 30 seconds
					aceTimers["done_flag"] = self:ScheduleTimer(mdCD_Done, 30)
					
					mdOnCD = true
				end
			end
		--removal of the 4 sec transfer buff
		elseif subevent == "SPELL_AURA_REMOVED" then
			if IsInGroup() then
				isTransferring[sName] = false
				if self.db.profile.showBars and self.idents[sName] then
					local r, g, b = unpack(spellID == 35079 and self.db.profile.cooldownColor or self.db.profile.tott_cooldownColor)
					self.idents[sName].redirecting = false
					self.idents[sName].timer:SetStatusBarColor(r, g, b, 1)
					self.idents[sName].timer:Show()
					self.idents[sName].redirect:Hide()
				end
				if self.db.profile.showFade then
					if spellID == 35079 then
						self:PrintMessage(strformat(L["Misdirection fades from %s"], dName), sName == pname)
					else
						self:PrintMessage(strformat(L["Tricks fades from %s"], dName), sName == pname)
					end
				end
			end
		end
	--readiness casts, should pickup all hunters in the group
	elseif spellID == 23989 then
		if IsInGroup() then
			if subevent == "SPELL_CAST_SUCCESS" then
				if sName == pname and mdOnCD then
					self:CancelCooldownTimers() --cancel all CD message events
					mdOnCD = nil
				end
				if self.db.profile.showReadiness then
					self:PrintMessage(strformat(self.db.profile.readiness, sName), sName == pname)
				end
				if self.db.profile.showSelf and self.db.profile.showBars then
					self:ReadinessCheck(sName)
				end
			end
		end
	end
end

function SimpleMD:BuffRotCheck(name)
	rottenTricks[name] = true
	if self.idents[name] then
		self:StopTimerBar(self:GetTimerIndexByName(name))
	end
end

function SimpleMD:CancelCooldownTimers()
	for k, v in pairs(aceTimers) do
		self:CancelTimer(k, true)
	end
	wipe(aceTimers)
end

--Function for broadcasting the cooldown messages
--Do nothing if player is dead or ghost since they can't MD anymore (thanks Cerqua)
function SimpleMD:CooldownBroadcast(message)
	if not UnitIsDeadOrGhost("player") then
		self:PrintMessage(message, true)
	end
end

--see if the player is in a raid or party
--if they are not: clear the CD bars
function SimpleMD:GroupStatus()
	if GetNumPartyMembers() == 0 or (not UnitInRaid("player")) then
		self:ClearTimerBars()
		self:CancelCooldownTimers()
	end
end

--Disable the bars and immediately cancel all running bars
function SimpleMD:DisableBars()
	if self.db.profile.showBars then
		self.db.profile.showBars = false
	else
		self.db.profile.showBars = true
	end
	
	self:ClearTimerBars()
end
