--$Revision: 231 $
--$Date: 2011-03-24 19:38:07 +0000 (Thu, 24 Mar 2011) $
--project version: 3.3.5
local LSM = LibStub("LibSharedMedia-3.0")
---		Upvalue Globals		----------
local floor = math.floor
local pairs = pairs
local strformat = string.format
local tinsert = table.insert
local tremove = table.remove
local strfind = string.find
local strsub = string.sub
local strsplit = strsplit
local unpack = unpack
--------------------------------------
local timercount = 0

local lastUpdate = 0
local function SMD_OnUpdate(self, elapsed)
	lastUpdate = lastUpdate + elapsed
	if lastUpdate < 0.06 then return end
	
	lastUpdate = 0
	
	local t
	for k, v in pairs(SimpleMD.timerbars) do
		if not t then t = GetTime() end
		if v.running then
			v.elapsed = t - v.start
			if v.redirecting then v.redirectElapsed = t - v.redirectStart end
			if v.stop <= t then
				SimpleMD:StopTimerBar(k)
			else
				SimpleMD:UpdateTimerBar(k)
			end
		end
	end	
end

function SimpleMD:ClearTimerBars()
	for i = table.getn(self.timerbars), 1, -1 do
		self.timerbars[i]:Hide()
		self.idents[self.timerbars[i].caster] = nil
		tinsert(self.recyclePile, tremove(self.timerbars))
		timercount = timercount - 1
	end
	self.frame:Hide()
end

function SimpleMD:ReadinessCheck(name)
	if self.idents[name] then
		self.idents[name].timer:SetValue(self.idents[name].reversed and 1 or 0)
		self:StopTimerBar(self:GetTimerIndexByName(name))
	end
end

function SimpleMD:UpdateTimerBar(index)
	local t = self.timerbars[index].time - self.timerbars[index].elapsed
	
	if self.timerbars[index].redirecting then
		self:UpdateRedirectBar(index)
	end
	
	local newtimetext
	
	local h = floor(t/3600)
	local m = t - (h*3600)
	m = floor(m/60)
	local s = t - ((h*3600) + (m*60))
	
	if s < 10 then
		newtimetext = strformat("%1.1f", s)
	else
		newtimetext = strformat("%.0f", floor(s))
	end
	
	self.timerbars[index].timetext:SetText(newtimetext)
	
	local percent = t / self.timerbars[index].time
	local reverse = self.timerbars[index].reversed
	self.timerbars[index].timer:SetValue(reverse and 1-percent or percent)
end

function SimpleMD:UpdateRedirectBar(index)
	local t = self.timerbars[index].redirectTime - self.timerbars[index].redirectElapsed
	
	local h = floor(t/3600)
	local m = t - (h*3600)
	m = floor(m/60)
	local s = t - ((h*3600) + (m*60))
	
	local newtimetext = strformat("%1.1f", s)
	
	self.timerbars[index].redirecttext:SetText(newtimetext)
	
	local percent = t / self.timerbars[index].redirectTime
	local reverse = self.timerbars[index].reversed
	self.timerbars[index].redirect:SetValue(reverse and 1-percent or percent)
end

function SimpleMD:StopTimerBar(index)
	if not index then return end
	self.timerbars[index].running = false
	if not self.timerbars[index].stayonscreen then
		for k, v in pairs(self.timerbars) do
			if k == 1 then
				--nothing
			elseif k == 2 then
				if self.timerbars[index].growup then
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("BOTTOM", self.frame, "TOP", 10, -5)
				else
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("TOP", self.frame, "BOTTOM", 10, 5)
				end
			else
				if self.timerbars[index].growup then
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("BOTTOM", self.timerbars[k-1], "TOP", 0, 0)
				else
					self.timerbars[k]:ClearAllPoints()
					self.timerbars[k]:SetPoint("TOP", self.timerbars[k-1], "BOTTOM", 0, 0)
				end
			end
		end
		self:RecycleTimerBar(index)
	else
		self.timerbars[index].timetext:SetText("")
		local i = strfind(self.timerbars[index].text:GetText(), " ")
		local temp = strsub(self.timerbars[index].text:GetText(), 1, i-1)
		self.timerbars[index].text:SetJustifyH("CENTER")
		self.timerbars[index].text:SetText(temp.." ready!")
		
		local reverse = self.timerbars[index].reversed
		self.timerbars[index].timer:SetValue(reverse and 0 or 1)
	end
end

function SimpleMD:GetTimerIndexByName(name)
	for k, v in pairs(self.timerbars) do
		if v.caster == name then
			return k
		end
	end
end

function SimpleMD:RecycleTimerBar(index)
	local alias = self.timerbars[index]
	if not alias then return end
	
	alias:Hide()
	timercount = timercount - 1
	tinsert(self.recyclePile, alias)
	self.idents[self.timerbars[index].caster] = nil
	tremove(self.timerbars, index)
	
	--if there are no more bars displayed
	--hide the frame with the OnUpdate script
	if timercount == 0 then
		self.frame:Hide()
	end
end

function SimpleMD:ReanchorTimerBars(growth)
	for k, v in pairs(self.timerbars) do
		if k == 1 then
			if self.timerbars[k].growup == growth then return end --if the present setting is the same as the new, bail out
			if growth then
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("BOTTOM", self.frame, "TOP", 10, -5)
				self.timerbars[k].growup = growth
			else
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("TOP", self.frame, "BOTTOM", 10, 5)
				self.timerbars[k].growup = growth
			end
		elseif k >= 2 then
			if growth then
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("BOTTOM", self.timerbars[k-1], "TOP", 0, 0)
				self.timerbars[k].growup = growth
			else
				self.timerbars[k]:ClearAllPoints()
				self.timerbars[k]:SetPoint("TOP", self.timerbars[k-1], "BOTTOM", 0, 0)
				self.timerbars[k].growup = growth
			end
		end
	end
end

function SimpleMD:RefreshTimerBar(alias, caster, target, runtime, reverse, stay, growth, isMD)
	local r, g, b = unpack(isMD and self.db.profile.barColor or self.db.profile.tott_barColor)
	alias.timer:SetStatusBarColor(r, g, b, 1)
	alias.timerbg:SetVertexColor(unpack(isMD and self.db.profile.bgColor or self.db.profile.tott_bgColor))
	alias.timerbg:SetAlpha(self.db.profile.bg_alpha)
	alias.timer:SetValue(1)
	alias.text:SetJustifyH("LEFT")
	if target then
		alias.text:SetText(caster.." - "..target)
		alias.text2:SetText(caster.." - "..target)
	else
		alias.text:SetText(caster)
		alias.text2:SetText(caster)
	end
	alias.timetext:SetText(runtime)
	alias.timer:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	alias.timerbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	
	r, g, b = unpack(isMD and self.db.profile.transferColor or self.db.profile.tott_transferColor)
	alias.redirect:SetStatusBarColor(r, g, b, 1)
	alias.redirectbg:SetVertexColor(unpack(isMD and self.db.profile.transferBG or self.db.profile.tott_transferBG))
	alias.redirectbg:SetAlpha(self.db.profile.bg_alpha)
	alias.redirect:SetValue(1)
	alias.redirect:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	alias.redirectbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	alias.redirecttext:SetText(isMD and "4" or "6")
	
	local curTime = GetTime()
	alias.start = curTime
	alias.stop = curTime + runtime
	alias.elapsed = 0
	alias.time = runtime
	alias.redirectTime = isMD and 4 or 6
	alias.redirectElapsed = 0
	alias.running = true
	alias.redirecting = false
	alias.reversed = reverse
	alias.stayonscreen = stay
end

local function DisableMouse(frame)
	if frame:IsMouseEnabled() then
		frame:EnableMouse(false)
	end
	if frame:GetChildren() then
		for _,child in pairs({frame:GetChildren()}) do
			if child:IsMouseEnabled() then
				child:EnableMouse(false)
			end
			DisableMouse(child)
		end 
	end
end

function SimpleMD:CreateTimerBar(caster, target, runtime, reverse, stay, growth, isMD)
	--strip off server names, otherwise text can overrun the bar
	if target then target = strsplit("-", target) end
	if caster then caster = strsplit("-", caster) end
	
	if self.idents[caster] then
		return self:RefreshTimerBar(self.idents[caster], caster, target, runtime, reverse, stay, growth, isMD)
	end
	
	timercount = timercount + 1
	
	local t
	if #self.recyclePile > 0 then
		t = tremove(self.recyclePile)
	else
		t = CreateFrame("BUTTON", nil, self.frame)
	end
	
	t:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t:ClearAllPoints()
	if timercount == 1 then
		if growth then
			t:SetPoint("BOTTOM", self.frame, "TOP", 10, -5)
		else
			t:SetPoint("TOP", self.frame, "BOTTOM", 10, 5)
		end
	else
		if growth then
			t:SetPoint("BOTTOM", self.timerbars[timercount-1], "TOP", 0, 0)
		else
			t:SetPoint("TOP", self.timerbars[timercount-1], "BOTTOM", 0, 0)
		end
	end
	
	if not t.timer then
		t.timer = CreateFrame("STATUSBAR", nil, t)
	end
	t.timer:ClearAllPoints()
	t.timer:SetPoint("TOPLEFT", t, "TOPLEFT")
	t.timer:SetPoint("BOTTOMRIGHT", t, "BOTTOMRIGHT")
	t.timer:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.timer:GetStatusBarTexture():SetHorizTile(false)
	t.timer:GetStatusBarTexture():SetVertTile(false)
	local r, g, b = unpack(isMD and self.db.profile.barColor or self.db.profile.tott_barColor)
	t.timer:SetStatusBarColor(r, g, b, 1)
	t.timer:SetMinMaxValues(0, 1)
	t.timer:SetValue(1)
	
	if not t.timerbg then
		t.timerbg = t.timer:CreateTexture(nil, "BACKGROUND")
	end
	t.timerbg:ClearAllPoints()
	t.timerbg:SetAllPoints(t.timer)
	t.timerbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.timerbg:SetVertexColor(unpack(isMD and self.db.profile.bgColor or self.db.profile.tott_bgColor))
	t.timerbg:SetAlpha(self.db.profile.bg_alpha)
	
	if not t.redirect then
		t.redirect = CreateFrame("STATUSBAR", nil, t)
	end
	t.redirect:ClearAllPoints()
	t.redirect:SetPoint("TOPLEFT", t, "TOPLEFT")
	t.redirect:SetPoint("BOTTOMRIGHT", t, "BOTTOMRIGHT")
	t.redirect:SetStatusBarTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.redirect:GetStatusBarTexture():SetHorizTile(false)
	t.redirect:GetStatusBarTexture():SetVertTile(false)
	r, g, b = unpack(isMD and self.db.profile.transferColor or self.db.profile.tott_transferColor)
	t.redirect:SetStatusBarColor(r, g, b, 1)
	t.redirect:SetMinMaxValues(0, 1)
	t.redirect:SetValue(1)
	t.redirect:Hide()
	
	if not t.redirectbg then
		t.redirectbg = t.redirect:CreateTexture(nil, "BACKGROUND")
	end
	t.redirectbg:ClearAllPoints()
	t.redirectbg:SetAllPoints(t.redirect)
	t.redirectbg:SetTexture(LSM:Fetch('statusbar', self.db.profile.texture))
	t.redirectbg:SetVertexColor(unpack(isMD and self.db.profile.transferBG or self.db.profile.tott_transferBG))
	t.redirectbg:SetAlpha(self.db.profile.bg_alpha)
	
	if not t.icon then
		t.icon = t:CreateTexture()
	end
	t.icon:SetTexture(isMD and self.md_tex or self.tott_tex)
	t.icon:ClearAllPoints()
	t.icon:SetPoint("RIGHT", t, "LEFT", 0, 0)
	t.icon:SetTexCoord(.07, .93, .07, .93)
	t.icon:SetWidth(self.db.profile.barHeight * self.db.profile.barScale)
	t.icon:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	
	if not t.text then
		t.text = t.timer:CreateFontString(nil, "LOW")
	end
	t.text:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.text:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.text:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.text:SetTextColor(self.db.profile.barTextColor[1], self.db.profile.barTextColor[2], self.db.profile.barTextColor[3], 1)
	t.text:SetJustifyH("LEFT")
	t.text:SetJustifyV("MIDDLE")
	t.text:ClearAllPoints()
	t.text:SetPoint("TOP", t.timer, "TOP", 5, 0)
	if target then
		t.text:SetText(caster.."  -  "..target)
	else
		t.text:SetText(caster)
	end
	
	if not t.timetext then
		t.timetext = t.timer:CreateFontString(nil, "LOW")
	end
	t.timetext:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.timetext:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.timetext:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.timetext:SetTextColor(self.db.profile.barTextColor[1], self.db.profile.barTextColor[2], self.db.profile.barTextColor[3], 1)
	t.timetext:SetJustifyH("RIGHT")
	t.timetext:SetJustifyV("MIDDLE")
	t.timetext:ClearAllPoints()
	t.timetext:SetPoint("TOP", t.timer, "TOP", -5, 0)
	t.timetext:SetText(runtime)
	t.timetext:Show()
	
	if not t.text2 then
		t.text2 = t.redirect:CreateFontString(nil, "LOW")
	end
	t.text2:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.text2:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.text2:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.text2:SetTextColor(self.db.profile.barTextColor[1], self.db.profile.barTextColor[2], self.db.profile.barTextColor[3], 1)
	t.text2:SetJustifyH("LEFT")
	t.text2:SetJustifyV("MIDDLE")
	t.text2:ClearAllPoints()
	t.text2:SetPoint("TOP", t.redirect, "TOP", 5, 0)
	if target then
		t.text2:SetText(caster.."  -  "..target)
	else
		t.text2:SetText(caster)
	end
	
	if not t.redirecttext then
		t.redirecttext = t.redirect:CreateFontString(nil, "LOW")
	end
	t.redirecttext:SetWidth(self.db.profile.barWidth * self.db.profile.barScale)
	t.redirecttext:SetHeight(self.db.profile.barHeight * self.db.profile.barScale)
	t.redirecttext:SetFont(LSM:Fetch('font', self.db.profile.font), self.db.profile.textSize)
	t.redirecttext:SetTextColor(self.db.profile.barTextColor[1], self.db.profile.barTextColor[2], self.db.profile.barTextColor[3], 1)
	t.redirecttext:SetJustifyH("RIGHT")
	t.redirecttext:SetJustifyV("MIDDLE")
	t.redirecttext:ClearAllPoints()
	t.redirecttext:SetPoint("TOP", t.redirect, "TOP", -5, 0)
	t.redirecttext:SetText("4")
	t.redirecttext:Show()
	
	local curTime = GetTime()
	t.start = curTime
	t.stop = curTime + runtime
	t.elapsed = 0
	t.time = runtime
	t.redirectElapsed = 0
	t.redirectTime = isMD and 4 or 6
	t.running = true
	t.redirecting = false
	t.reversed = reverse
	t.growup = growth
	t.stayonscreen = stay
	t.caster = caster
	
	t:SetFrameStrata("LOW")
	
	--show the OnUpdate frame to activate the script
	self.frame:Show()
	
	t:Show()
	
	DisableMouse(t)
	
	tinsert(self.timerbars, t)
	self.idents[caster] = t
end

function SimpleMD:CreateAnchor(text)
	local f = CreateFrame("BUTTON", "smdAnchor", UIParent)
	local g = CreateFrame("FRAME", nil, UIParent)
	f:SetWidth(200)
	f:SetHeight(25)
	g:SetWidth(200)
	g:SetHeight(25)
	
	if self.db.profile.position.x and self.db.profile.position.y and self.db.profile.position.anchor and self.db.profile.position.point then
		f:ClearAllPoints()
		g:ClearAllPoints()
		f:SetPoint(self.db.profile.position.point, UIParent, self.db.profile.position.anchor, self.db.profile.position.x, self.db.profile.position.y)
		g:SetPoint(self.db.profile.position.point, UIParent, self.db.profile.position.anchor, self.db.profile.position.x, self.db.profile.position.y)
	else
		f:SetPoint("CENTER", UIParent, "CENTER")
		g:SetPoint("CENTER", UIParent, "CENTER")
	end
	
	f:SetScript("OnDragStart", function() f:StartMoving() end )
	f:SetScript("OnDragStop",
		function ()
			f:StopMovingOrSizing()
			local point, _, anchor, x, y = f:GetPoint()
			SimpleMD.db.profile.position.x = floor(x)
			SimpleMD.db.profile.position.y = floor(y)
			SimpleMD.db.profile.position.anchor = anchor
			SimpleMD.db.profile.position.point = point
			g:ClearAllPoints()
			g:SetPoint(point, UIParent, anchor, x, y)
		end)
	
	f:SetBackdrop({
		bgFile = [[Interface\Tooltips\UI-Tooltip-Background]],
		edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],
		tile = false, tileSize = 16, edgeSize = 16,
		insets = { left = 5, right = 5, top = 5, bottom = 5 }
		})
		
	f:SetBackdropColor(0, 1, 0, .65)
	f:SetMovable(true)
	f:RegisterForDrag("LeftButton")
	f:SetClampedToScreen(true)
	f:EnableMouse(true)
	
	f.text = f:CreateFontString(nil, "OVERLAY")
	f.text:SetFontObject(GameFontNormalSmall)
	f.text:ClearAllPoints()
	f.text:SetTextColor(1, 1, 1, 1)
	f.text:SetWidth(200)
	f.text:SetHeight(25)
	f.text:SetPoint("TOP", f, "TOP")
	f.text:SetJustifyH("CENTER")
	f.text:SetJustifyV("MIDDLE")
	f.text:SetText(text)
	
	f:Hide()
	g:Hide()
	
	g:SetScript("OnUpdate", SMD_OnUpdate)
	g:EnableMouse(false)
	
	return f, g
end
